(function() {
  //    FILE:LoginView
  //    PROJECT:fw-mobile
  //    Created by Rafa Dorado on 2/18/13
  //    Farmerswife SL.
  define(['jquery', 'underscore', 'Handlebars', 'Backbone', 'moment', 'models/user/UserModel', 'models/event/EventModel', 'collections/event/EventCollection', 'models/timereport/TimereportModel', 'collections/timereport/TimereportCollection', 'collections/objects/ObjectCollection', 'views/event/EventListView', 'views/notification/NotificationListView', 'collections/notifications/NotificationCollection', 'collections/todos/TodoCollection', 'PrecompiledTemplates'], function($, _, Handlebars, Backbone, Moment, UserModel, EventModel, EventCollection, TimereportModel, TimereportCollection, ObjectCollection, EventListView, NotificationListView, NotificationCollection, TodoCollection) {
    var LoginView;
    return LoginView = (function() {
      var accepted_terms, appc_enabled, brand_name, hide_user_pass_login, oidc_enabled, oidc_provider_id, oidc_provider_name, password_complexity_msg, prelogin_message, userName;

      class LoginView extends Backbone.View {
        initialize(reqMdl) {
          var jsonReq, response, that, xmlReq;
          this.reqMdl = reqMdl;
          //console.log 'Init LoginView'
          if (window.isGuerrilla()) {
            this.loginClicked();
          }
          //Get the pre-login message when the login view load
          that = this;
          jsonReq = this.reqMdl.get('JGetServerInfo');
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest_sync(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj, objeto;
            jsonObj = data;
            objeto = JSON.stringify(jsonObj);
            prelogin_message = data.Result.prelogon_text;
            prelogin_message = prelogin_message.replace(/^\s*$(?:\r\n?|\n)/gm, "</p><p>");
            prelogin_message = `<p>${prelogin_message}</p>`;
            password_complexity_msg = data.Result.passwordComplexityMsg;
            oidc_enabled = data.Result.oidc_enabled;
            appc_enabled = data.Result.appleconnect_enabled;
            oidc_provider_id = data.Result.oidc_provider_id;
            oidc_provider_name = data.Result.oidc_provider_name;
            hide_user_pass_login = data.Result.hide_user_pass_login;
            brand_name = data.Result.brandName;
            window.FW_COMPANY_NAME = data.Result.company;
            if (oidc_enabled) {
              $('#btn-login-external').show();
            } else {
              $('#btn-login-external').hide();
            }
            if (appc_enabled) {
              return $('#btn-login-appc').show();
            } else {
              return $('#btn-login-appc').hide();
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          });
        }

        attributes() {
          return {
            'data-role': 'page'
          };
        }

        events() {
          return {
            'tap #btn-login': 'loginClicked',
            'tap #btn-accept-terms': 'acceptedLogin',
            'tap #id-btn-submit-newP': 'btnSubmitNewPassword',
            'tap #btn-login-external': 'loginExternalClicked',
            'tap #btn-login-appc': 'loginAppleConnectClicked'
          };
        }

        render() {
          var error, login_external, login_state, params, pswd, template, title, titleResult, token;
          template = Handlebars.templates['LoginView'];
          params = this.getQueryParams(document.location.search);
          this.$el.html(template({
            isGuerrilla: window.isGuerrilla(),
            oidc_enabled: oidc_enabled,
            oidc_provider_id: oidc_provider_id,
            oidc_provider_name: oidc_provider_name,
            appc_enabled: appc_enabled,
            hide_user_pass_login: hide_user_pass_login,
            brand_name: brand_name
          }));
          if (params != null ? params.expired : void 0) {
            error = 'Your session has expired, please log in again';
            this.$el.find('#errors').text(error);
            this.$el.find('#errors').show();
          }
          //if window.isGuerrilla() then $.mobile.loading('show')
          this.$el;
          title = params.title;
          login_state = params.login_state;
          token = window.localStorage.getItem('oidcToken');
          login_external = 0;
          if (title !== "" && title !== void 0) {
            titleResult = title.substr(0, 10);
            if (login_state === "success") {
              login_external = 1;
              userName = "oidc";
              pswd = token;
              return this.__do_login(userName, pswd);
            }
          }
        }

        loginClicked(event) {
          var pswd, that;
          if (event != null) {
            event.preventDefault();
          }
          if (event != null) {
            event.stopPropagation();
          }
          if (window.isGuerrilla()) {
            window.localStorage.clear();
            userName = 'Peter';
            pswd = '1';
          } else {
            userName = $('#username').val();
            pswd = $('#password').val();
          }
          that = this;
          return that.__do_login(userName, pswd);
        }

        
          // LOGGIN WITH OPPEN ID
        loginExternalClicked(event) {
          var jsonReq, response, xmlReq;
          if (event != null) {
            event.preventDefault();
          }
          if (event != null) {
            event.stopPropagation();
          }
          jsonReq = this.reqMdl.get('JLoginExternal');
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj, token, tokenIndex, url;
            jsonObj = data;
            url = jsonObj.OIDCGetURLResponse.Url;
            tokenIndex = url.search("state");
            token = url.substr(tokenIndex + 6);
            window.localStorage.setItem("oidcToken", token);
            return window.location.href = url;
          });
        }

        loginAppleConnectClicked(event) {
          var jsonReq, response, xmlReq;
          if (event != null) {
            event.preventDefault();
          }
          if (event != null) {
            event.stopPropagation();
          }
          jsonReq = this.reqMdl.get('JLoginExternal');
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var jsonObj, objeto, url;
            jsonObj = data;
            url = jsonObj.OIDCGetURLResponse.Url;
            //url = jsonObj.Result.Url 
            objeto = JSON.stringify(url);
            return window.location.href = url;
          });
        }

        
          //WHEN USER ACCEPT PRE-LOGIN MESSAGE   
        acceptedLogin(event) {
          var that;
          that = this;
          accepted_terms = 1;
          return that.loginClicked(event);
        }

        
          //WHEN PASSWORD IS EXPIRED AND USER NEEDS TO CHANGE IT  
        btnSubmitNewPassword(event) {
          var jsonReq, newP1, newP2, pswd, response, that, xmlReq;
          event.preventDefault();
          event.stopPropagation();
          newP1 = $('#id-input-newP-1').val();
          newP2 = $('#id-input-newP-2').val();
          pswd = $('#password').val();
          if (newP1 === newP2) {
            jsonReq = this.reqMdl.get('JChangeExpiredPassword');
            this.reqMdl.__setNodeValue(jsonReq, 'oldPassword', pswd);
            this.reqMdl.__setNodeValue(jsonReq, 'newPassword', newP1);
            this.reqMdl.__setNodeValue(jsonReq, 'username', userName);
            xmlReq = this.reqMdl.__getXML(jsonReq);
            that = this;
            response = this.reqMdl.__send_server_xmlrequest(xmlReq);
            return response.done(function(data, textStatus, jqXHR) {
              var errorMsg, jsonObj;
              jsonObj = data;
              //console.log data
              if (jsonObj.Result.isExpiredSession === '1' || jsonObj.Result.isExpiredSession === 1) {
                window.localStorage.clear();
                window.location.href = 'index.html?expired=1';
              }
              if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
                $('.success_msg').html('Password Succesfully Changed');
                $('.success_msg').show().delay(3000).fadeOut();
                $('#pwd-newP').hide();
                $('#errors').hide();
                $('#login_form').show();
                return $('#password').val('');
              } else {
                errorMsg = `<p>${jsonObj.Result.error}</p>`;
                $('#errors').html(errorMsg);
                $('#errors').hide();
                return $('#errors').fadeIn("slow");
              }
            }).fail(function(data, textStatus, jqXHR) {
              //console.log "ERROR #{textStatus} "+data
              return false;
            }).always(function(data, textStatus) {
              return $.mobile.loading('hide');
            });
          } else {
            $('#errors').html('Password miss match, please try again');
            $('#errors').hide();
            return $('#errors').fadeIn("slow");
          }
        }

        __do_login(userName, pswd) {
          var jsonReq, response, that, timezone, xmlReq;
          that = this;
          jsonReq = this.reqMdl.get('JLogin');
          jsonReq.acceptTc = accepted_terms;
          timezone = Moment().format('Z').replace(/:/, ''); // FOR HAVING FORMAT +0200
          this.reqMdl.__setNodeValue(jsonReq, 'userName', userName);
          this.reqMdl.__setNodeValue(jsonReq, 'key', pswd);
          this.reqMdl.__setNodeValue(jsonReq, 'timezone', timezone);
          xmlReq = this.reqMdl.__getXML(jsonReq);
          response = this.reqMdl.__send_server_xmlrequest(xmlReq);
          return response.done(function(data, textStatus, jqXHR) {
            var errorMsg, eventsCol, jsonObj, notCol, objCol, ref, ref1, usr;
            jsonObj = data;
            if (jsonObj.Result.isError === "0" || jsonObj.Result.isError === 0) {
              //CHECK PERMISIONS FOR USER
              if (!(((ref = _.where(jsonObj.Result.ProfileProperties.ProfileProperty, {
                'key': "AllowedAccessTiers:allowIPhoneApp"
              })) != null ? (ref1 = ref[0]) != null ? ref1['value'] : void 0 : void 0) === 1)) {
                $('#errors').html("Your user does not have permissions to use this client");
                $('#errors').show();
                return;
              }
              //CREATE USER
              usr = that.__save_user(jsonObj);
              //CREATE TIMEREPORTS
              that.__save_timereports(jsonObj);
              //TODOS COLLECTION
              that.__save_todos(jsonObj.Result.Todo);
              //TODAY EVENTS Collection
              eventsCol = that.__get_today_events(usr);
              //FETCH OBJECTS COL
              objCol = new ObjectCollection();
              objCol.get_simple_objects(usr);
              objCol.get_favorites_objects(usr);
              if (usr.__enabled_notifications() && usr.__has_unread_notifications()) {
                notCol = new NotificationCollection();
                notCol.get_notifications(usr);
                return $.mobile.jqmNavigator.replaceAll(new NotificationListView(usr, notCol), {
                  transition: "none"
                });
              } else {
                return $.mobile.jqmNavigator.replaceAll(new EventListView(usr, eventsCol), {
                  transition: "none"
                });
              }
            } else {
              if (data.Result.error) {
                errorMsg = `<p>${data.Result.error}</p>`;
                if (data.Result.errorCode === -7) {
                  errorMsg += `<p>${password_complexity_msg}</p>`;
                }
              } else if (data.Result.rejectedMessage) {
                errorMsg = `<p>${data.Result.rejectedMessage}</p>`;
              } else {
                errorMsg = '<p>Error, please try again later</p>';
              }
              //ERROR CODE -10 IF USER DID NOT ACCEPT BEFORE THE PRE-LOGIN MESSAGE
              if (data.Result.errorCode === -10) {
                $('#prelogin_container').show();
                $('#login_form').hide();
                return $('#prelogin_msg').html(prelogin_message);
              
              //ERROR CODE -7 IF USER PASSWORD IS EXPIRED
              } else if (data.Result.errorCode === -7) {
                $('#errors').html(errorMsg);
                $('#errors').hide();
                $('#errors').fadeIn("slow");
                $('#login_form').hide();
                $(':input', '#pwd-newP').val('');
                return $('#pwd-newP').show();
              } else {
                $('#errors').html(errorMsg);
                $('#errors').hide();
                return $('#errors').fadeIn("slow");
              }
            }
          }).fail(function(data, textStatus, jqXHR) {
            //console.log "ERROR #{textStatus} "+data
            return false;
          });
        }

        __save_user(response) {
          var ref, ref1, ref2, res, usr, usrData;
          res = response.Result;
          //CREATE USER SETTINGS MODEL
          usrData = {
            'id': 1,
            'dayStartsAt': res.dayStartsAt,
            'timereport_updated_at': Moment().format('YYYY-MM-DD hh:mm:ss'),
            'loggedAt': Moment().format('YYYY-MM-DD hh:mm:ss'),
            'defaultEventStartTime': res.defaultEventStartTime,
            'defaultEventStopTime': res.defaultEventStopTime,
            'hasPDFPrinterAvailable': res.hasPDFPrinterAvailable,
            'notificationsNotReadCount': res.notificationsNotReadCount,
            'sessionID': res.sessionID,
            'userIsAClient': res.userIsAClient,
            'userIsAResource': res.userIsAResource,
            'usersFullName': res.usersFullName,
            'usersObjectID': res.usersObjectID,
            'usersObjectType': res.usersObjectType,
            'usesAMPM': res.usesAMPM,
            'usesObjectTracking': res.usesObjectTracking,
            'weekStartsOnSunday': res.weekStartsOnSunday,
            'eventsBookableTimeFrameStart': res.eventsBookableTimeFrameStart,
            'eventsBookableTimeFrameStop': res.eventsBookableTimeFrameStop,
            'eventsTimereportableTimeFrameStart': res.eventsTimereportableTimeFrameStart,
            'eventsTimereportableTimeFrameStop': res.eventsTimereportableTimeFrameStop,
            'eventsViewableTimeFrameStart': res.eventsViewableTimeFrameStart,
            'eventsViewableTimeFrameStop': res.eventsViewableTimeFrameStop,
            'EventsObjectProperties': res.EventsObjectProperties,
            'ProfileProperties': res.ProfileProperties,
            'DefaultBreaks': res.DefaultBreaks,
            'usesTravelExpenses': res.usesTravelExpenses,
            'Holidays': res.Holidays,
            'openInvolvedTabAsDefault': res.openInvolvedTabAsDefault,
            'showNoteOnDayPlanView': res.showNoteOnDayPlanView,
            'hideUserNumber': res.hideUserNumber,
            'pendingRequestReminderHours': res.pendingRequestReminderHours,
            'requestWorkingHoursStart': res.requestWorkingHoursStart,
            'requestWorkingHoursStop': res.requestWorkingHoursStop,
            'usePendingRequestReminderHours': res.usePendingRequestReminderHours,
            'useRequestWorkingHours': res.useRequestWorkingHours,
            'maxDate': res.maxDate
          };
          window.MAXDATE = new Date(res.maxDate);
          if (res.usesTravelExpenses) {
            usrData['travelExpensesAutoSelectPerDiemWhenAllowed'] = res.travelExpensesAutoSelectPerDiemWhenAllowed;
            usrData['TravelExpenseCurrencies'] = (ref = res.TravelExpenseCurrencies) != null ? ref.TravelExpenseCurrency : void 0;
            usrData['TravelExpenseCashAdvanceTypes'] = (ref1 = res.TravelExpenseCashAdvanceTypes) != null ? ref1.TravelExpenseCashAdvanceType : void 0;
            usrData['TravelExpenseExpenseTypes'] = (ref2 = res.TravelExpenseExpenseTypes) != null ? ref2.TravelExpenseExpenseType : void 0;
          }
          usr = new UserModel(usrData);
          usr.save();
          return usr;
        }

        __get_today_events(usr) {
          var eventCol;
          eventCol = new EventCollection();
          return eventCol.get_day_events(usr, Moment());
        }

        __save_timereports(response) {
          var col, reports;
          reports = response.Result.Timereport;
          col = new TimereportCollection();
          if (_.isArray(reports)) {
            _.each(reports, function(r) {
              return col.create(r);
            });
          } else if (reports) {
            col.create(reports);
          }
          return col;
        }

        __save_todos(todos) {
          var col;
          col = new TodoCollection();
          if (_.isArray(todos)) {
            return _.each(todos, function(r) {
              return col.create(r);
            });
          } else if (todos) {
            return col.create(todos);
          }
        }

        getQueryParams(qs) {
          var params, re, tokens;
          qs = qs.split("+").join(" ");
          params = {};
          tokens = null;
          re = /[?&]?([^=]+)=([^&]*)/g;
          while ((tokens = re.exec(qs))) {
            params[decodeURIComponent(tokens[1])] = decodeURIComponent(tokens[2]);
          }
          return params;
        }

      };

      prelogin_message = "";

      accepted_terms = 0;

      userName = "";

      oidc_enabled = 0;

      appc_enabled = 0;

      password_complexity_msg = "";

      oidc_provider_id = "";

      oidc_provider_name = "";

      hide_user_pass_login = 0;

      brand_name = "farmerswife";

      return LoginView;

    }).call(this);
  });

}).call(this);
